<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\Select2Control;
use STM_E_W\Widgets\Controls\ContentControls\IconsControl;
use STM_E_W\Widgets\Controls\StyleControls\SliderControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupBorderControl;
use STM_E_W\Widgets\Controls\StyleControls\DimensionsControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupTypographyControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class AttributeBoxes extends WidgetBase {

	use HeadingControl;
	use Select2Control;
	use SliderControl;
	use GroupTypographyControl;
	use GroupBorderControl;
	use DimensionsControl;
	use ColorControl;
	use IconsControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION, array( 'jquery' ) );
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-attribute-boxes';
	}

	public function get_title() {
		return esc_html__( 'Attribute Boxes', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-grid-view';
	}

	protected function register_controls() {
		$this->stm_start_content_controls_section( 'attr_boxes_content', __( 'General', 'motors-elementor-widgets' ) );

		if ( function_exists( 'stm_is_multilisting' ) && stm_is_multilisting() ) {

			$this->stm_ew_add_heading(
				'listing_type_heading',
				array(
					'label'     => esc_html__( 'Default Listing type', 'motors-elementor-widgets' ),
					'separator' => 'before',
				)
			);

		}

		$this->stm_ew_add_select_2(
			'attr_boxes_taxonomies',
			array(
				'label'       => __( 'Categories', 'motors-elementor-widgets' ),
				'description' => __( 'Enter slug of listing category', 'motors-elementor-widgets' ),
				'options'     => $this->motors_get_listing_taxonomies(),
				'multiple'    => true,
			)
		);

		$this->stm_ew_add_icons(
			'attr_boxes_default_icon',
			array(
				'label'            => esc_html__( 'Default Icon', 'motors-elementor-widgets' ),
				'description'      => __( 'Displays when selected category has no icon', 'motors-elementor-widgets' ),
				'skin'             => 'inline',
				'fa4compatibility' => 'icon',
				'default'          => array(
					'value' => 'fas fa-car',
				),
			),
		);

		if ( function_exists( 'stm_is_multilisting' ) && stm_is_multilisting() ) {

			$listing_types = Helper::stm_ew_multi_listing_types();

			if ( $listing_types ) {
				foreach ( $listing_types as $slug => $typename ) {
					if ( apply_filters( 'stm_listings_post_type', 'listings' ) !== $slug ) {

						$this->stm_ew_add_heading(
							'listing_type_' . $slug . '_heading',
							array(
								'label'     => esc_html( $typename ),
								'separator' => 'before',
							)
						);

						$this->stm_ew_add_select_2(
							'attr_boxes_taxonomies_' . $slug,
							array(
								'label'       => __( 'Categories', 'motors-elementor-widgets' ),
								'description' => __( 'Enter slug of listing category', 'motors-elementor-widgets' ),
								'options'     => Helper::stm_ew_multi_listing_search_filter_fields( $slug ),
								'multiple'    => true,
							)
						);

						$this->stm_ew_add_icons(
							'attr_boxes_default_icon_' . $slug,
							array(
								'label'            => esc_html__( 'Default Icon', 'motors-elementor-widgets' ),
								'description'      => __( 'Displays when selected category has no icon', 'motors-elementor-widgets' ),
								'skin'             => 'inline',
								'fa4compatibility' => 'icon',
								'default'          => array(
									'value' => 'fas fa-box',
								),
							),
						);

					}
				}
			}
		}

		$this->stm_end_control_section();

		$this->stm_start_style_controls_section( 'section_styles', esc_html__( 'General', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_slider(
			'attr_boxes_items_gap',
			array(
				'label'      => esc_html__( 'Items gap', 'motors-elementor-widgets' ),
				'size_units' => array(
					'px',
				),
				'range'      => array(
					'px'      => array(
						'min'  => 0,
						'max'  => 40,
						'step' => 1,
					),
					'default' => array(
						'unit' => 'px',
						'size' => 20,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .single-listing-attribute-boxes' => 'gap: {{SIZE}}{{UNIT}};',
				),
			),
		);

		$this->stm_ew_add_heading(
			'attr_boxes_icon_heading',
			array(
				'label' => __( 'Icon', 'stm-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_slider(
			'attr_boxes_icon_size',
			array(
				'label'      => esc_html__( 'Icon Size', 'motors-elementor-widgets' ),
				'size_units' => array(
					'px',
				),
				'range'      => array(
					'px' => array(
						'min'  => 5,
						'max'  => 45,
						'step' => 1,
					),
				),
				'default'    => array(
					'unit' => 'px',
					'size' => 25,
				),
				'selectors'  => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item .icon' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			),
		);

		$this->stm_ew_add_color(
			'attr_boxes_icon_color',
			array(
				'label'     => esc_html__( 'Icon Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item .icon' => 'color: {{VALUE}};',
				),
			),
		);

		$this->stm_ew_add_heading(
			'attr_boxes_heading_heading',
			array(
				'label' => __( 'Heading', 'stm-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_color(
			'attr_boxes_heading_color',
			array(
				'label'     => esc_html__( 'Heading color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item .label-text' => 'color: {{VALUE}};',
				),
			),
		);

		$this->stm_ew_add_group_typography(
			'attr_boxes_heading_typography',
			array(
				'label'    => esc_html__( 'Heading typography', 'motors-elementor-widgets' ),
				'exclude'  => array(
					'font_style',
					'text_decoration',
					'word_spacing',
				),
				'selector' => '{{WRAPPER}} .single-listing-attribute-boxes .item .label-text',
			),
		);

		$this->stm_ew_add_dimensions(
			'attr_boxes_heading_margin',
			array(
				'label'     => esc_html__( 'Heading margin', 'motors-elementor-widgets' ),
				'default'   => array(
					'top'    => '0',
					'right'  => '0',
					'bottom' => '0',
					'left'   => '0',
				),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item .label-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			),
		);

		$this->stm_ew_add_heading(
			'attr_boxes_value_heading',
			array(
				'label' => __( 'Value', 'stm-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_color(
			'attr_boxes_value_color',
			array(
				'label'     => esc_html__( 'Value color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item .value-text' => 'color: {{VALUE}};',
				),
			),
		);

		$this->stm_ew_add_group_typography(
			'attr_boxes_value_typography',
			array(
				'label'    => esc_html__( 'Value typography', 'motors-elementor-widgets' ),
				'exclude'  => array(
					'font_style',
					'text_decoration',
					'word_spacing',
				),
				'selector' => '{{WRAPPER}} .single-listing-attribute-boxes .item .value-text',
			),
		);

		$this->stm_ew_add_heading(
			'attr_boxes_item_heading',
			array(
				'label' => __( 'Item Box', 'stm-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_dimensions(
			'attr_boxes_item_padding',
			array(
				'label'     => esc_html__( 'Item Box padding', 'motors-elementor-widgets' ),
				'default'   => array(
					'top'    => '10',
					'right'  => '10',
					'bottom' => '10',
					'left'   => '10',
				),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			),
		);

		$this->stm_ew_add_dimensions(
			'attr_boxes_item_border_radius',
			array(
				'label'     => __( 'Item Box border radius', 'motors-elementor-widgets' ),
				'default'   => array(
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'isLinked' => true,
				),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'attr_boxes_item_background',
			array(
				'label'     => esc_html__( 'Item Box background', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .single-listing-attribute-boxes .item' => 'background-color: {{VALUE}};',
				),
			),
		);

		$this->stm_end_control_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'pro/widgets/single-listing/attribute-boxes', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	private function motors_get_listing_taxonomies() {
		$filters = stm_listings_attributes(
			array(
				'key_by' => 'slug',
			)
		);

		$filter_fields = array();

		foreach ( $filters as $filter ) {
			$filter_fields[ $filter['slug'] ] = $filter['slug'];
		}

		return $filter_fields;
	}

}
